/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Created by yumeng 2/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float s( float b ) {
    return abs( b / 2. - mod( iGlobalTime* 20.0, b ) );
}

float sArea(vec2 p1,vec2 p2,vec2 p3)
{
    float s;
    s = 0.5*((p1.x*p2.y-p2.x*p1.y)+(p2.x*p3.y-p3.x*p2.y)+(p3.x*p1.y-p1.x*p3.y));
    return abs(s);
}
//?????????????
vec2 getLineColor(vec2 st, vec2 ed)
{
    vec2 p = gl_FragCoord.xy / 10.0;
   
    float a = 10.0;
    float sr = sArea(p,st,ed);
    float c = 0.0;
    
    vec2 min_b = min(st,ed);
    vec2 max_b = max(st,ed);
    
    float delta = 2.0;
    if(p.x<min_b.x-delta||p.y<min_b.y-delta||p.x>max_b.x+delta||p.y>max_b.y+delta)
    {
        return vec2(a,c);
    }
    
    if ( a > sr)
    {
        a = sr/10.0;
        c =0.6*p.y+p.x;
        c = c+iGlobalTime*3.8;
        //c = mod(iGlobalTime,c);
    }
    return vec2(a,c); 
}
void main() {
    float a = 1e1,d, m = 0.;
	vec2 p = gl_FragCoord.xy / a;

    vec2 res = iResolution.xy/a;
    
    vec2 st = vec2(res.x*0.38,res.y);
    vec2 ed = vec2(res.x*0.49,res.y*0.76);
    vec2 result = getLineColor(st,ed);
    
    st = vec2(res.x*0.62,res.y);
    ed = vec2(res.x*0.51,res.y*0.76);
    if(result.y == 0.0) 
    {
        result = getLineColor(st,ed);
        //result.y = 0.2;
    }
    
    st = vec2(res.x*0.32,res.y*0.73);
    ed = vec2(res.x*0.68,res.y*0.73);
    if(result.y == 0.0)
    {
        result = getLineColor(st,ed);
        //result.y = 2.45;
        //result.x = 1.0;
    }
    
    st = vec2(res.x*0.38,res.y*0.51);
    ed = vec2(res.x*0.62,res.y*0.51);
    if(result.y == 0.0)
    {
        result = getLineColor(st,ed);
    }
    
    st = vec2(res.x*0.28,res.y*0.3);
    ed = vec2(res.x*0.72,res.y*0.3);
    if(result.y == 0.0)
    {
        result = getLineColor(st,ed);
    }
    
    st = vec2(res.x*0.5,res.y*0.73);
    ed = vec2(res.x*0.5,0.);
    if(result.y == 0.0)
    {
        result = getLineColor(st,ed);
    }
    m = result.y;
    a = result.x;

    vec3 c;
	for ( int i = 0 ; i < 3 ; i++ ) {
        m /= 3.;
		c[ i ] = fract( m );
	}
    vec2 q = 0.6 * (2.0*gl_FragCoord.xy-iResolution.xy)/min(iResolution.y,iResolution.x);
	float r = length(q);
    vec3 bcol = vec3(0.8+0.1*q.y,0.2,0.2-0.1*q.y);
    bcol *= 1.0 - 0.5*r;
    
    vec3 ccol = clamp(c/a,0.,1.);
    
    gl_FragColor = vec4 ( mix(bcol,ccol,ccol.x), 1.0 );
}